
#ifndef _1_CRYS_ATP_TST_FLOW_Acceptance_h_H
#define _1_CRYS_ATP_TST_FLOW_Acceptance_h_H



/*
 * All the includes that are needed for code using this module to
 * compile correctly should be #included here.
 */
#include "CRYS.h"
#include "CRYS_ATP_TST_Defines.h"
#include "CRYS_FLOW.h"

#if TST_USE_FLOW_DATA/*In case no test vectors are selected - code disabled*/

#ifdef __cplusplus
extern "C"
{
#endif


  /*
   *  Object %name    : %
   *  State           :  %state%
   *  Creation date   :  Tue Nov 14 10:18:14 2007
   *  Last modified   :  %modify_time%
   */
  /** @file
   *  \brief A brief description of this module
   *
   *  \version CRYS_ATP_TST_FLOW_Acceptance.h#1:incl:1
   *  \author Annag
   *  \remarks Copyright (C) 2007 by Discretix Technologies Ltd.
   *           All Rights reserved
   */
   

/************************ Defines *******************************/
/************************ Enums *********************************/
/************************ Typedefs  *****************************/
/************************ Structs  ******************************/


/************************ Public Variables **********************/
/************************ Public Functions **********************/

/*****************************************************************************
 * Function Name:                                                           
 *  CRYS_ATP_TST_FLOW_PARALLEL_STATIC_Acceptance
 *  
 * Inputs:
 *  None
 *
 * Outputs: 
 *  CRYSError_t - Function error return                                     
 *
 * Description:                                                                 
 *  This function Is a Acceptance test for FLOW API's
 
 * Algorithm:     
 *	This function goes through several test vectors and runs 
 *  CRYS_ATP_TST_FLOW_PARALLEL_Acceptance test for each vector.
 ******************************************************************************/                                
CRYSError_t CRYS_ATP_TST_FLOW_PARALLEL_STATIC_Acceptance ( void );

/*****************************************************************************
 * Function Name:                                                           
 *  CRYS_ATP_TST_FLOW_PARALLEL_DYNAMIC_Acceptance
 *  
 * Inputs:
 *  None
 *
 * Outputs: 
 *  CRYSError_t - Function error return                                     
 *
 * Description:                                                                 
 *  This function Is a Acceptance test for FLOW API's
 * Algorithm:     
 *	This function goes through several test vectors and runs 
 *  CRYS_ATP_TST_FLOW_PARALLEL_Acceptance test for each vector.
 ******************************************************************************/                                
CRYSError_t CRYS_ATP_TST_FLOW_PARALLEL_DYNAMIC_Acceptance ( void );


/*****************************************************************************
 * Function Name:                                                           
 *  CRYS_ATP_TST_FLOW_SEQUENTIALLY_DYNAMIC_Acceptance
 *  
 * Inputs:
 *  None
 *
 * Outputs: 
 *  CRYSError_t - Function error return                                     
 *
 * Description:                                                                 
 *  This function Is a Acceptance test for FLOW API's
 
 * Algorithm:     
 *	This function goes through several test vectors and runs 
 *  CRYS_ATP_TST_FLOW_SEQUENTIALLY_Acceptance test for each vector.
 ******************************************************************************/                                
CRYSError_t CRYS_ATP_TST_FLOW_SEQUENTIALLY_DYNAMIC_Acceptance ( void );


/*****************************************************************************
 * Function Name:                                                           
 *  CRYS_ATP_TST_FLOW_SEQUENTIALLY_STATIC_Acceptance
 *  
 * Inputs:
 *  None
 *
 * Outputs: 
 *  CRYSError_t - Function error return                                     
 *
 * Description:                                                                 
 *  This function Is a Acceptance test for FLOW API's
 
 * Algorithm:     
 *	This function goes through several test vectors and runs 
 *  CRYS_ATP_TST_FLOW_SEQUENTIALLY_Acceptance test for each vector.
 ******************************************************************************/                                
CRYSError_t CRYS_ATP_TST_FLOW_SEQUENTIALLY_STATIC_Acceptance ( void );


/***************************
 * Function Name:
 * 	CRYS_ATP_TST_FLOW_DYNAMIC_AddBuffers_Acceptance
 *
 * Inputs:
 * 	none
 *
 * Outputs:
 * 	CRYSError_t - Function error return
 *
 * Description:
 * This function runs dynamic FLOW Acceptance tests with add buffers functionality.
 *
 **************************/
CRYSError_t CRYS_ATP_TST_FLOW_DYNAMIC_AddBuffers_Acceptance(void);

/***************************
 * Function Name:
 * 	CRYS_ATP_TST_FLOW_DYNAMIC_Acceptance_WithAdditionalEngines
 *
 * Inputs:
 * 	none
 *
 * Outputs:
 * 	CRYSError_t - Function error return
 *
 * Description:
 * This function runs dynamic FLOW Acceptance tests with additional engines 
 * at the middle of the flow.
 *
 **************************/
CRYSError_t CRYS_ATP_TST_FLOW_DYNAMIC_Acceptance_WithAdditionalEngines(void);

/***************************
 * Function Name:
 * 	CRYS_ATP_TST_FLOW_DYNAMIC_Acceptance
 *
 * Inputs:
 * 	none
 *
 * Outputs:
 * 	CRYSError_t - Function error return
 *
 * Description:
 * This function runs dynamic FLOW Acceptance tests.
 *
 **************************/
CRYSError_t CRYS_ATP_TST_FLOW_DYNAMIC_Acceptance(void);

/***************************
 * Function Name:
 * 	CRYS_ATP_TST_FLOW_STATIC_Cyclic_Acceptance
 *
 * Inputs:
 * 	none
 *
 * Outputs:
 * 	CRYSError_t - Function error return
 *
 * Description:
 * This function runs static cyclic FLOW Acceptance tests.
 *
 **************************/
CRYSError_t CRYS_ATP_TST_FLOW_STATIC_Cyclic_Acceptance(void);

/***************************
 * Function Name:
 * 	CRYS_ATP_TST_FLOW_STATIC_Acceptance_WithAdditionalEngines
 *
 * Inputs:
 * 	none
 *
 * Outputs:
 * 	CRYSError_t - Function error return
 *
 * Description:
 * This function runs static FLOW Acceptance tests with additional engines 
 * at the middle of the flow.
 *
 **************************/
CRYSError_t CRYS_ATP_TST_FLOW_STATIC_Acceptance_WithAdditionalEngines(void);

/***************************
 * Function Name:
 * 	CRYS_ATP_TST_FLOW_STATIC_Acceptance
 *
 * Inputs:
 * 	none
 *
 * Outputs:
 * 	CRYSError_t - Function error return
 *
 * Description:
 * This function runs static FLOW Acceptance tests.
 *
 **************************/
CRYSError_t CRYS_ATP_TST_FLOW_STATIC_Acceptance(void);


#ifdef __cplusplus
}
#endif

#endif

#endif
